#include <stdio.h>
#include <stdlib.h>
#include "audioc.h"
#include "uspl.h"

/* Reverb Wave Routine Delays an audio object by specified amounts */
long reverb_wav(AudioC &Wav,float delay, float amp, AudioC &newwave)
{
long delay_samps;
float *fbuf_l=NULL,*fbuf_r=NULL;
float *tbuf;
long fbuf_samps;
float scale_factor;
long orig_samps;
long step=1;
long status=1;
char *cptr;
short *sptr;
long one=1;
long cur_samp=0;
float f;

   // compute scale factor
   scale_factor=amp/100.0;
   // compute the number of samples to delay by
   f=delay/1000.0*Wav.GetSampleRate();
   delay_samps=f;
   
   // compute max size of float buf we will use
   orig_samps=Wav.GetNumSamps()/Wav.GetNumChan();
   fbuf_samps=orig_samps+delay_samps*3;

   if (fbuf_samps<=0) return 0;


   // allocate memory for temp buf
   tbuf=(float*) malloc(fbuf_samps*sizeof(float));
   if (tbuf==NULL) status=0;
   // allocate memory for 1 chan (always have at least 1)
   fbuf_l=(float*) malloc(fbuf_samps*sizeof(float));
   if (fbuf_l==NULL) status=0;

   // if we have 2 channels
   if (Wav.GetNumChan()==2)
   {
      step=2;
      fbuf_r=(float*) malloc(2*fbuf_samps*sizeof(float));
      if (fbuf_r==NULL) status=0;
   }

   // make sure we are ok
   if (status)
   {
      // clear the buffers
      vclr_(fbuf_l,&one,&fbuf_samps);
      if (step==2) vclr_(fbuf_r,&one,&fbuf_samps);
      vclr_(tbuf,&one,&fbuf_samps);
      sptr=(short*) Wav.GetBuffer();
      cptr=(char*) sptr;

      // demux data, convert to float in temp buffer
      // 1st case 8 bits/sample ie. 1 byte/samp
      if (Wav.GetBitsPerSamp()==8)
      {
         fltb_(cptr, &step, fbuf_r, &one, &orig_samps);
         // second channel if reqd
         if (step==2)
            fltb_(&cptr[1], &step, fbuf_l, &one, &orig_samps);
      }
      // 2nd case 16 bits/sample ie. 2 bytes/samp
      if (Wav.GetBitsPerSamp()==16)
      {
         flt2_(sptr, &step, fbuf_r, &one, &orig_samps);
         // second channel if reqd
         if (step==2)
            flt2_(&sptr[1], &step, fbuf_l, &one, &orig_samps);
      }

      // while we have enough room
      while (fbuf_samps-cur_samp>orig_samps)
      {

         cur_samp+=delay_samps;
         // do left channel
         // scale data & save in temp buf
         vsmul_(fbuf_l,&one,&scale_factor,tbuf,&one,&orig_samps);
         // add temp buf to original data
         vadd_(tbuf,&one,&fbuf_l[cur_samp],&one,&fbuf_l[cur_samp],&one,&orig_samps);

         //do right channel
         if (Wav.GetNumChan()==2)
         {
            // scale data & save in temp buf
            vsmul_(fbuf_r,&one,&scale_factor,tbuf,&one,&orig_samps);
            // add temp buf to original data
            vadd_(tbuf,&one,&fbuf_r[cur_samp],&one,&fbuf_r[cur_samp],&one,&orig_samps);
         }
         // adjust scale factor down
         scale_factor*=scale_factor;


      }

    }

   // change samples
   newwave.SetNumSamps(fbuf_samps);

   // convert & mux the data
   // 8 bit data
   if (newwave.GetBitsPerSamp()==8)
   {
       cptr=(char *)newwave.GetBuffer();
       fixbn_(fbuf_l,&one,(unsigned char *)cptr,&step,&fbuf_samps);
       if (newwave.GetNumChan()==2)
        fixbn_(fbuf_r,&one,(unsigned char *)&cptr[1],&step,&fbuf_samps);
   }

   // 16 bit data
   if (newwave.GetBitsPerSamp()==16)
   {
       sptr=(short *)newwave.GetBuffer();
       fix2n_(fbuf_l,&one,sptr,&step,&fbuf_samps);
       if (newwave.GetNumChan()==2)
        fix2n_(fbuf_r,&one,&sptr[1],&step,&fbuf_samps);
   }

   // free up old buffers
   if (fbuf_l!=NULL) free(fbuf_l);
   if (fbuf_r!=NULL) free(fbuf_r);
   if (tbuf!=NULL) free(tbuf);

   if (status==0) return (0); else return(1);

}



